clear
option = inputdlg('Figure 3: Enter A or B to choose figure to plot','Fig3 Plotting');
option = upper(char(option));
load('3A_Pcntvar.mat');
value = round(PC_pcntvar, 1);
p_value = PC_pval; 
if option=='A'

%% Figure 3A
PC = categorical ({'PC1', 'PC2', 'PC3', 'PC4', 'PC5'});
b = bar (PC, value);

xtips1 = b(1).XEndPoints;
ytips1 = b(1).YEndPoints;
labels1 = string(b(1).YData);
hold 
yyaxis left

ax = gca;
ax.FontSize = 12;
xlabel('Principal components of SVD')
ylabel('Percentage of explained variance (%)')
yyaxis right

plot (PC, p_value, 'r-^', 'MarkerFaceColor','r',  'LineWidth',1)
ylabel('P-value')

yyaxis right

y = 0.05;
yline (y, '-.r', 'Threshold', 'LineWidth',0.7);
yticks([0 0.05 0.2 0.4 0.6 0.8 1])
yticklabels ({'0', '0.05', '0.2', '0.4', '0.6', '0.8', '1'})
elseif option=='B'
%% Figure 3B

load('3B_geneContributeAging');
errhigh = 2.58*stdError_final;
errlow  = -2.58*stdError_final;
data = U_final;
x = categorical(geneName);
FigH = figure;
b = bar(x,data);
set(b,'FaceColor', [0, 0.75, 0.75], 'EdgeColor', [0, 0.75, 0.75]);
xticklabels(geneName)
ax = gca;
ax.FontSize = 12;
xlabel('Top causal genes in aging', 'FontSize',14)
ylabel('Saliences of genes on PC1', 'FontSize',14)
ax.XAxis.TickLength = [0 0];
ax.YAxis.TickLength = [0 0];
hold on
er = errorbar(x,data,errlow,errhigh);
er.Color = 'k';
er.LineStyle = 'none';
else
    print('No correct option chosen')
end
